 ; Ŀ
 ;   Gepta - get a point, offer a default, insert a block.                 
 ;   Copyright 2003, 2009 by Rocket Software Ltd.                          
 ;                                                                         
 ; 
 (DEFUN C:GEPTA (/ pa lisa osmo ss mxlst vhite)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Get a block name.                                                     
 ; 
  (setq lisa (getstring "Block: "))
 ; Ŀ
 ;   Find the middle base point of the last terminal block block           
 ;   inserted and save it to the variable Dopt.                            
 ; 
  (if (= (type dopt) 'LIST)
      (progn
           (setq pa (getpoint dopt "Insertion or <Return>: "))
           (if (null pa) (setq pa dopt)))
      (setq pa (getpoint "Insertion point: ")))
 ; Ŀ
 ;   Insert the block.  This was done at dimscale, but since terminal      
 ;   blocks aren't typically scaled this has been changed.                 
 ; 
 ; (command "insert" lisa pa (getvar "dimscale") "" 0)
  (command "insert" lisa pa 1 "" 0)
 ; Ŀ
 ;   Turn off running object snaps.                                        
 ; 
  (setq osmo (getvar "osmode"))
  (setvar "osmode" 0)
 ; Ŀ
 ;   Find the depth of the last entity.                                    
 ; 
  (if (not pussy) (load "puss"))
  (setq mxlst (puss (entlast)))
  (setq vhite (- (caddr mxlst) (cadddr mxlst)))
 ; Ŀ
 ;   Calculate the middle base point, save it.                             
 ;   This originally used the Lastpoint sysvar, but it appears to          
 ;   be unstable under some circumstances.                                 
 ; 
  (setq lastin (cdr (assoc 10 (entget (entlast)))))
  (setq dopt (polar lastin (* pi 1.5) vhite))
  (setvar "osmode" osmo)
 (princ))